/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.core.util;

import com.yollo.dmlreforged.common.items.ItemDataModel;
import com.yollo.dmlreforged.common.items.ItemGlitchSword;
import com.yollo.dmlreforged.common.mobmetas.MobMetaData;
import com.yollo.dmlreforged.common.mobmetas.MobMetaFactory;
import com.yollo.dmlreforged.core.init.ItemInit;
import com.yollo.dmlreforged.core.util.DataModelLevelupHelper;
import com.yollo.dmlreforged.core.util.NBTHelper;
import com.yollo.dmlreforged.core.util.TierHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DataModelHelper {
    public static NonNullList<ItemStack> getValidFromList(NonNullList<ItemStack> list) {
        NonNullList filteredList = NonNullList.m_122779_();
        for (ItemStack stack : list) {
            Item item = stack.m_41720_();
            if (!(item instanceof ItemDataModel)) continue;
            filteredList.add((Object)stack);
        }
        return filteredList;
    }

    public static ItemStack getModelFromMobKey(String mobKey) {
        ItemStack result = ItemStack.f_41583_;
        for (ItemDataModel dataModel : ItemInit.dataModels) {
            if (!dataModel.getMobKey().equals(mobKey)) continue;
            result = new ItemStack((ItemLike)dataModel);
        }
        return result;
    }

    public static boolean hasExtraTooltip(ItemStack stack) {
        return DataModelHelper.getExtraTooltip(stack) != null;
    }

    public static String getExtraTooltip(ItemStack stack) {
        return DataModelHelper.getMobMetaData(stack).getExtraTooltip();
    }

    public static String getMatterTypeName(ItemStack stack) {
        return DataModelHelper.getMobMetaData(stack).getType();
    }

    public static int getSimulationTickCost(ItemStack stack) {
        return DataModelHelper.getMobMetaData(stack).getSimulationTickCost();
    }

    public static String getMobKey(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemDataModel) {
            ItemDataModel model = (ItemDataModel)item;
            return model.getMobKey();
        }
        return "zombie";
    }

    public static MobMetaData getMobMetaData(ItemStack stack) {
        return MobMetaFactory.createMobMetaData(DataModelHelper.getMobKey(stack));
    }

    public static int getPristineChance(ItemStack stack) {
        return TierHelper.getPristineChance(DataModelHelper.getTier(stack));
    }

    public static MutableComponent getTierName(ItemStack stack, boolean getNextTierName) {
        return TierHelper.getTierName(DataModelHelper.getTier(stack), getNextTierName);
    }

    public static void increaseMobKillCount(ItemStack stack, ServerPlayer player) {
        int tier = DataModelHelper.getTier(stack);
        int i = DataModelHelper.getCurrentTierKillCount(stack);
        boolean isGlitchSwordEquipped = player.m_21205_().m_41720_() instanceof ItemGlitchSword;
        DataModelHelper.setCurrentTierKillCount(stack, i += isGlitchSwordEquipped ? 2 : 1);
        DataModelHelper.setTotalKillCount(stack, DataModelHelper.getTotalKillCount(stack) + 1);
        if (DataModelLevelupHelper.shouldIncreaseTier(tier, i, DataModelHelper.getCurrentTierSimulationCount(stack))) {
            player.m_5661_((Component)new TranslatableComponent("dmlreforged.tiers.increase_tier", new Object[]{stack.m_41786_(), DataModelHelper.getTierName(stack, true)}), true);
            DataModelHelper.setCurrentTierKillCount(stack, 0);
            DataModelHelper.setCurrentTierSimulationCount(stack, 0);
            DataModelHelper.setTier(stack, tier + 1);
        }
    }

    public static void increaseSimulationCount(ItemStack stack) {
        int tier = DataModelHelper.getTier(stack);
        int i = DataModelHelper.getCurrentTierSimulationCount(stack);
        DataModelHelper.setCurrentTierSimulationCount(stack, ++i);
        DataModelHelper.setTotalSimulationCount(stack, DataModelHelper.getTotalSimulationCount(stack) + 1);
        if (DataModelLevelupHelper.shouldIncreaseTier(tier, DataModelHelper.getCurrentTierKillCount(stack), i)) {
            DataModelHelper.setCurrentTierKillCount(stack, 0);
            DataModelHelper.setCurrentTierSimulationCount(stack, 0);
            DataModelHelper.setTier(stack, tier + 1);
        }
    }

    public static int getTier(ItemStack stack) {
        return NBTHelper.getInt(stack, "tier", 0);
    }

    public static void setTier(ItemStack stack, int tier) {
        NBTHelper.setInt(stack, "tier", tier);
    }

    public static int getCurrentTierKillCount(ItemStack stack) {
        return NBTHelper.getInt(stack, "killCount", 0);
    }

    public static void setCurrentTierKillCount(ItemStack stack, int count) {
        NBTHelper.setInt(stack, "killCount", count);
    }

    public static int getCurrentTierSimulationCount(ItemStack stack) {
        return NBTHelper.getInt(stack, "simulationCount", 0);
    }

    public static void setCurrentTierSimulationCount(ItemStack stack, int count) {
        NBTHelper.setInt(stack, "simulationCount", count);
    }

    public static int getTotalKillCount(ItemStack stack) {
        return NBTHelper.getInt(stack, "totalKillCount", 0);
    }

    public static void setTotalKillCount(ItemStack stack, int count) {
        NBTHelper.setInt(stack, "totalKillCount", count);
    }

    public static int getTotalSimulationCount(ItemStack stack) {
        return NBTHelper.getInt(stack, "totalSimulationCount", 0);
    }

    public static void setTotalSimulationCount(ItemStack stack, int count) {
        NBTHelper.setInt(stack, "totalSimulationCount", count);
    }

    public static double getCurrentTierKillCountWithSims(ItemStack stack) {
        return DataModelLevelupHelper.getCurrentTierKillCountWithSims(DataModelHelper.getTier(stack), DataModelHelper.getCurrentTierKillCount(stack), DataModelHelper.getCurrentTierSimulationCount(stack));
    }

    public static int getCurrentTierSimulationCountWithKills(ItemStack stack) {
        return DataModelLevelupHelper.getCurrentTierSimulationCountWithKills(DataModelHelper.getTier(stack), DataModelHelper.getCurrentTierKillCount(stack), DataModelHelper.getCurrentTierSimulationCount(stack));
    }

    public static double getKillsToNextTier(ItemStack stack) {
        return DataModelLevelupHelper.getKillsToNextTier(DataModelHelper.getTier(stack), DataModelHelper.getCurrentTierKillCount(stack), DataModelHelper.getCurrentTierSimulationCount(stack));
    }

    public static int getSimulationsToNextTier(ItemStack stack) {
        return DataModelLevelupHelper.getSimulationsToNextTier(DataModelHelper.getTier(stack), DataModelHelper.getCurrentTierKillCount(stack), DataModelHelper.getCurrentTierSimulationCount(stack));
    }

    public static int getTierRoofAsKills(ItemStack stack) {
        if (DataModelHelper.getTier(stack) == 4) {
            return 0;
        }
        return DataModelLevelupHelper.getTierRoof(DataModelHelper.getTier(stack), true);
    }

    public static int getTierRoof(ItemStack stack) {
        if (DataModelHelper.getTier(stack) == 4) {
            return 0;
        }
        return DataModelLevelupHelper.getTierRoof(DataModelHelper.getTier(stack), false);
    }
}

